<?php
class Kontener
{
  protected $tab = array(100, 200, 300, 400);
  public function getElement($index)
  {
    if(!is_numeric($index)){
      throw new InvalidArgumentException("Nieprawidłowy argument.");
    }
    $index = (integer) $index;
    if(!isSet($this->tab[$index])){
      throw new InvalidArgumentException("Nieprawidłowy argument.");
    }
    else{
      return $this->tab[$index];
    }
  }
  public function setElement($index, $wartosc)
  {
    if(!is_numeric($index)){
      throw new InvalidArgumentException("Nieprawidłowy argument \$index.");
    }

    if(!is_numeric($wartosc)){
      throw new InvalidArgumentException("Nieprawidłowy argument \$wartosc.");
    }

    $index = (integer) $index;
    $wartosc = (integer) $wartosc;

    if(isset($this->tab[$index])){
      throw new InvalidArgumentException("Nieprawidłowy argument \$index.");
    }

    $this->tab[$index] = $wartosc;

  }
}

$kontener = new Kontener();

$argc = $_SERVER['argc'];

if($argc != 2 && $argc != 3){
  echo "Wywołanie: php index.php indeks\n";
  echo "lub\n";
  echo "php index.php indeks wartosc\n";
  exit();
}
else if($argc == 2){
  $index = $_SERVER['argv'][1];

  try{
    $val = $kontener->getElement($index);
  }
  catch(InvalidArgumentException $e){
    echo "Wystąpił błąd: ", $e->getMessage();
    exit();
  }
  echo("Element o indeksie $index to $val.");
}
else{
  $index = $_SERVER['argv'][1];
  $wartosc = $_SERVER['argv'][2];

  try{
    $kontener->setElement($index, $wartosc);
  }
  catch(InvalidArgumentException $e){
    echo "Wystąpił błąd: ", $e->getMessage();
    exit();
  }

  echo "Element o indeksie $index został ustawiony na: ";
  echo $kontener->getElement($index);
  echo "\n";
}

?>
